#ifndef ZMODELER_STRUCT_FACETBL_H_INCLUDED
#define ZMODELER_STRUCT_FACETBL_H_INCLUDED

//--------------------------------------------------
//    Table of faces
//--------------------------------------------------
class DllExport tFaceTable
{
public:
//-------------------------
//  data members
  tFace     DummyFace;
  long      FaceAmount;
  tFace      *Table;

//-------------------------
//  construction
  tFaceTable();
  tFaceTable(int amount);//creates empty Table
  ~tFaceTable();

//-------------------------
//  functions
  void  Init(int amount, BOOL release=FALSE); //creates empty Table

  tFace*      DuplicateTable(); //creates a duplicate of the Table

  void AddFace(tFace f);//Adds single face
  void AddFace(tIndex i1, tIndex i2, tIndex i3);//Adds single face
  void CreateFace(tFace f);//same as AddFace
  void CreateFace(tIndex i1, tIndex i2, tIndex i3);//same as AddFace
  void DeleteFace(long index);//Deletes single face

  void DeleteFaces(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden);//Deletes marked/selected faces
  //---------------------------------------------------
  // decreases indexes, supposing that marked/selected
  // vertices will be deleted from Table of vertices
  //---------------------------------------------------
  void SlideIndexes(  tVertexTable *VertTable, BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden);
  void ReorientFaces( BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden);//flip marked/selected faces

  void ToHasFlagSetFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
              BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
              BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToHasFlagChangeFlag(  BOOL HasMark, BOOL HasSelect, BOOL HasDisable, BOOL HasHidden,
                BOOL HasntMark, BOOL HasntSelect, BOOL HasntDisable, BOOL HasntHidden,
                BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);
  void ToAllChangeFlag(  BOOL SetMark, BOOL SetSelect, BOOL SetDisable, BOOL SetHidden);


  BOOL Selected(long index);  //tells whether the custom face has Z3D_FLAG_SELECTED in nFlags
  BOOL Marked(long index);  //tells whether the custom face has Z3D_FLAG_MARKED in nFlags
  BOOL Disabled(long index);  //tells whether the custom face has Z3D_FLAG_DISABLED in nFlags
  BOOL Hidden(long index);  //tells whether the custom face has Z3D_FLAG_HIDDEN in nFlags
  void Select(long index);  //selects one face
  void UnSelect(long index);  //deselects one face
  void Mark(long index);    //marks one face
  void UnMark(long index);  //unmarks one face
  void Disable(long index);  //disables one face
  void Enable(long index);  //enables one face
  void Hide(long index);    //hides one face
  void UnHide(long index);  //un-hides one face
  void SelectAll();      //selects all faces in Table
  void UnSelectAll();      //deselects all faces in Table
  void MarkAll();        //marks all faces in Table
  void UnMarkAll();      //unmarks all faces in Table
  void DisableAll();      //disables all faces in Table
  void EnableAll();      //enables all faces in Table
  void HideAll();        //hides all faces in Table
  void UnHideAll();      //unhides all faces in Table

  tFace& Get(int index);    //safe access to Table members
};

#endif

